# Бот службы поддержки

Как работает бот. Есть сам бот, и есть приватная группа. В бот пишет клиент. В группе сидят сотрудники поддержки. Когда клиент пишет в бот сообщение, ему выдается номер и оно передается в группу. Сотрудники могут ответить на обращение, решить проблему и закрыть тикет. Раз в сутки запускается очистка базы от закрытых тикетов. В качестве идентификатора используется порядковый номер строки в базе на момент добавления, поэтому коды тикетов получаются короткими и удобными.

## Как запустить

0. Вам нужен `docker compose` на сервере. Установите его подходящим для вашей системы способом и следуйте дальнейшей инструкции.
1. Создайте в папке с приложением пустую папку с именем `db` и пустой файл с именем .env
2. Запишите в файл `.env` следующие строки и не забудьте сохранить изменения

```bash
TELEGRAM_SUPPORT_CHAT_ID=-1234567 # ID приватного чата, где сидят сотрудники
TELEGRAM_TOKEN=00000000:AaaaaaAaaaaaaaAa-bBBBBbbbbb # ID бота из BotFather
APP_NAME=Моё приложение # название вашего приложения
```

3. Выполните в консоли сервера следующую команду

```bash
docker compose up -d --build
```

4. Все готово, можете закрывать консоль

## Команды

Клиент в чате с ботом может писать только одну команды `/start`. Все остальные команды предназначены для приватного чата.

В чате сотрудники могут вызывать следующие команды

- /help - показать подсказку по командам
- /tickets - вывести список 10 самых новых открытых тикетов. Если открытых тикетов больше - будет показан знак `...`
- /closed - вывести количество закрытых тикетов. Эти тикеты будут удалены через какое-то время
- /answer - ответить на тикет. Сообщение будет переслано клиенту
- /close - закрыть тикет. Он будет помечен для удаления, а клиенту придет благодарность за обращение
